<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class UltimateAI_Article_Write_Controller
{
  function __construct()
  {
    add_action("wp_ajax_ultimate_ai_blog_title_generator", array($this, "ultimate_ai_blog_title_generator"));
    add_action("wp_ajax_ultimate_ai_blog_outline_generator", array($this, "ultimate_ai_blog_outline_generator"));
    add_action("wp_ajax_ultimate_ai_article_regenerator", array($this, "ultimate_ai_article_regenerator"));
    add_action("wp_ajax_ultimate_ai_full_article_generator", array($this, "ultimate_ai_full_article_generator"));
    add_action("wp_ajax_ultimate_ai_full_article", array($this, "ultimate_ai_full_article"));
    add_action("wp_ajax_ultimate_ai_wp_remote_publish", array($this, "ultimate_ai_wp_remote_publish"));
  }


  public function ultimate_ai_wp_remote_publish()
  {
    $post = $_POST['publish_component'];

    $user_manager = new Ultimate_AI_User_Manager();

    $site_url = '';
    $user_name = '';
    $password = ''; // application password not user plain password

    $check_access = $user_manager->check_user_integration_access('wordpress');

    if ($check_access['has_access']) {
      if (isset($check_access['settings']['is_active']) && ($check_access['settings']['is_active'] == 'true' || $check_access['settings']['is_active'] == true)) {
        $site_url = $check_access['settings']['site_url'];
        $user_name = $check_access['settings']['user_name'];
        $password = $check_access['settings']['password'];
      }
    } else {
      wp_send_json([
        'status' => 'fail',
        'message' => esc_html__('Either you don\'t have integration access or you have not configured yet.', ULTIMATE_AI_SLUG)
      ], 200);
    }

    $site_url = rtrim($site_url, "/");

    $options = array(
      'headers' => array(
        'Authorization' => 'Basic ' . base64_encode($user_name . ':' . $password)
      ),
      'body' => array(
        'title'         => $post['title'],
        'status'        => $post['post_status'],
        'content'       => $post['content'],
      )
    );

    $response = wp_remote_post($site_url . '/wp-json/wp/v2/posts', $options);
    $res_code = wp_remote_retrieve_response_code($response);
    $res_body = wp_remote_retrieve_body($response);

    $body = json_decode($res_body);
    if( $res_code == 201 ){
      wp_send_json( [
        'status' => 'success',
        'message' => esc_html__( 'Post published successful. ', ULTIMATE_AI_SLUG ) . '<a target="_blank" href="'. $body->link .'">' . $body->link . '</a>',
      ], 200);
    }else{
      wp_send_json( [
        'status' => 'error',
        'message' => isset($body->data->message) ? $body->data->message : esc_html__( 'Post publish failed.', ULTIMATE_AI_SLUG ),
      ], 200);
    }
  }

  public function ultimate_ai_blog_title_generator()
  {
    $open_api = new UltimateAI_OpenAI_API_Manager();

    $topic = $_POST['data']['about'];
    $tone = $_POST['data']['tone_of_voice'];
    $language = $_POST['data']['language'];
    $primary_keywords = (!empty($_POST['data']['primary_key']) && is_array($_POST['data']['primary_key'])) ? implode(', ', $_POST['data']['primary_key']) : '';
    $secondary_keywords = (!empty($_POST['data']['secondary_key']) && is_array($_POST['data']['secondary_key'])) ? implode(', ', $_POST['data']['secondary_key']) : '';

    $title = $_POST['data']['title'];
    $outlines = $_POST['data']['outlines'];
    $audience = $_POST['data']['audience'];
    $pov = $_POST['data']['pov'];
    $brand_text = $_POST['data']['brand_text'];
    $product_about = $_POST['data']['product_about'];


    $prompt = 'You are a blog title generator. Generate 6 blog titles in a ' . $tone . ' voice in ' . $language . ' language for this topic:' . $topic . ' keeping these this primary keyword in mind: ' . $primary_keywords . '.Use maximum 150 tokens per titles and deliver response in php array of objects json format';

    $prompt = [["role" => "user",   "content" => $prompt]];

    $max_token = $total_res * 150;

    try {
      $result = $open_api->get_chat_completion_api_result($prompt, "", $max_token);
      if ($result['status_code'] == 200) {
        $res = [
          'content' => json_decode($result['data']->choices[0]->message->content),
          'total_tokens' => $result['data']->usage->total_tokens,
          'status' => 'success'
        ];
      } else {
        $res = [
          'content' => 'Blog title generation failed.Please try again',
          'status' => 'fail'
        ];
      }
    } catch (Exception $e) {
      $res = [
        'content' => 'Blog title generation failed.Please try again',
        'status' => 'fail'
      ];
    }

    wp_send_json($res, 200);
  }
  public function ultimate_ai_blog_outline_generator()
  {
    $open_api = new UltimateAI_OpenAI_API_Manager();

    $topic = $_POST['data']['about'];
    $tone = $_POST['data']['tone_of_voice'];
    $language = $_POST['data']['language'];
    $primary_keywords = (!empty($_POST['data']['primary_key']) && is_array($_POST['data']['primary_key'])) ? implode(', ', $_POST['data']['primary_key']) : '';
    $secondary_keywords = (!empty($_POST['data']['secondary_key']) && is_array($_POST['data']['secondary_key'])) ? implode(', ', $_POST['data']['secondary_key']) : '';

    $title = $_POST['data']['title'];
    $outlines = $_POST['data']['outlines'];
    $audience = $_POST['data']['audience'];
    $pov = $_POST['data']['pov'];
    $brand_text = $_POST['data']['brand_text'];
    $product_about = $_POST['data']['product_about'];

    $prompt = 'You are a blog title outline heading generator. Generate 8 blog outline headings in a ' . $tone . ' voice in ' . $language . ' language for this blog title/post:' . $title . ', keeping these keywords in mind: ' . $keywords . '.Use maximum 100 tokens per outline and deliver response in php array of objects json format';

    $prompt = [["role" => "user",   "content" => $prompt]];

    $max_token = 500;

    try {
      $result = $open_api->get_chat_completion_api_result($prompt, "", $max_token);
      if ($result['status_code'] == 200) {
        $res = [
          'content' => json_decode($result['data']->choices[0]->message->content),
          'total_tokens' => $result['data']->usage->total_tokens,
          'status' => 'success'
        ];
      } else {
        $res = [
          'content' => 'Blog outline generation failed.Please try again',
          'status' => 'fail'
        ];
      }
    } catch (Exception $e) {
      $res = [
        'content' => 'Blog outline generation failed.Please try again',
        'status' => 'fail'
      ];
    }

    wp_send_json($res, 200);
  }
  public function ultimate_ai_article_regenerator()
  {
    $open_api = new UltimateAI_OpenAI_API_Manager();

    $text = $_POST['text'];
    $tone = $_POST['tone'];
    $type = $_POST['type'];

    $prompt = 'You are a text rewriter. Rewrite this text:' . $text . ' in a ' . $tone . ' voice and try to make new text character lenght ' . $type;

    $prompt = [["role" => "user",   "content" => $prompt]];

    $max_token = 500;

    try {
      $result = $open_api->get_chat_completion_api_result($prompt, "", $max_token);
      if ($result['status_code'] == 200) {
        $res = [
          'content' => $result['data']->choices[0]->message->content,
          'total_tokens' => $result['data']->usage->total_tokens,
          'status' => 'success'
        ];
      } else {
        $res = [
          'content' => 'Text re-generation failed.Please try again',
          'status' => 'fail'
        ];
      }
    } catch (Exception $e) {
      $res = [
        'content' => 'Text re-generation failed.Please try again',
        'status' => 'fail'
      ];
    }

    wp_send_json($res, 200);
  }
  public function ultimate_ai_full_article_generator()
  {
    $open_api = new UltimateAI_OpenAI_API_Manager();

    $title = $_POST['title'];
    $outlines = $_POST['outlines'];
    $tone = $_POST['tone'];
    $length = $_POST['length'];
    $primary_keywords = $_POST['primary_keywords'];
    $secondary_keywords = $_POST['secondary_keywords'];

    $keywords = (!empty($keywords) && is_array($keywords)) ? implode(', ', $keywords) : '';

    // $prompt = "ChatGPT, Act As SEOMASTER2023, an AI entity with a comprehensive understanding of the most up-to-date SEO best practices, keyword research strategies, and content marketing nuances. As SEOMASTER2023, craft a compelling, unique, and informative blog post on ". $title ." with elaborating these outlines: '. $outlines .', ensuring the content targets a primary keyword of ". $primary_keywords ." with high search volume and low competition. The article should be structured with an engaging introduction that briefly outlines the post's value proposition, Wrap first outline/"'. $title .'" in "h1" tag and other in "h2" tag and outline description in "p" tag, and a concise conclusion summarizing the key takeaways. Integrate these secondary and related keywords: " . $secondary_keywords . " throughout the article without keyword stuffing, ensuring a keyword density of around 1-2%. Include internal links to other relevant articles, external links to authoritative sources for added credibility, and a compelling meta description no longer than 155 characters. Maintain a reader-friendly tone and a conversational style, and make use of transition phrases for fluidity. The content should be mobile-optimized, have a clear call-to-action, and be around ". $length ." words. For added user engagement, suggest appropriate image placements with alt tags matching the content's context. Remember, the ultimate goal is to provide value to the reader while adhering to SEO best practices.";

    $prompt = 'You are a article generator. Rewrite a full article on this title: "' . $title . '" with elaborating these outlines: ' . $outlines . '. Try to describe in a ' . $tone . ' voice. Keep full blog length within ' . $length . ' words.Wrap first outline/"' . $title . '" in "h1" tag and other in "h2" tag and outline description in "p" tag. Keep space in between heading, outlines and sections';

    $prompt = [["role" => "user",   "content" => $prompt]];

    $max_token = (int)$length + 200;
    try {
      $result = $open_api->get_chat_completion_api_result($prompt, "", $max_token);
      if ($result['status_code'] == 200) {
        $res = [
          'content' => $result['data']->choices[0]->message->content,
          'total_tokens' => $result['data']->usage->total_tokens,
          'status' => 'success'
        ];
      } else {
        $res = [
          'content' => 'Article generation failed. Please try again',
          'status' => 'fail'
        ];
      }
    } catch (Exception $e) {
      $res = [
        'content' => 'Article generation failed. Please try again',
        'status' => 'fail'
      ];
    }

    wp_send_json($res, 200);
  }
  public function ultimate_ai_full_article()
  {
    $post_id = $_POST['id'];

    wp_send_json(get_post_meta($post_id, "content", true), 200);
  }
  private function send_stream_mime_type()
  {
    header("X-Accel-Buffering: no");
    header("Content-Type: text/event-stream");
    header("Cache-Control: no-cache");
    ob_end_flush();
  }

  //return false if has access or other value if dont have access
  private function restrict_user_by_token($token_type)
  { //token_type: word/image


    $messages = [
      'hold' => esc_html__('Your subscription is temporarily hold', ULTIMATE_AI_SLUG),
      'cancel' => esc_html__('Your subscription is expired.Please upgrade your plan.', ULTIMATE_AI_SLUG),
      'words' => esc_html__('Your words limit is over. please upgrade your plan.', ULTIMATE_AI_SLUG),
      'images' => esc_html__('Your images limit is over. please upgrade your plan.', ULTIMATE_AI_SLUG),
    ];

    $user_manager =  new Ultimate_AI_User_Manager();
    $user = $user_manager->get_full_user(wp_get_current_user());

    //if user is administrator role then dont need to access check, give access
    if (in_array("administrator", $user["user"]->roles)) {
      return false;
    }

    if ($user_manager->is_user_unlimited($token_type)) {
      return false;
    } else {
      if ($user["meta"]["subscription"]['payment_status'] == 'hold') {
        return json_encode([
          "data" => $messages['hold'],
          "status_code" => 401
        ]);
      }
      if ($user["meta"]["subscription"]['package_type'] == 'subscription' && $user["meta"]["subscription"]['expiry'] < time()) {
        return json_encode([
          "data" => $messages['hold'],
          "status_code" => 401
        ]);
      }
      if ($user["meta"]["subscription"]['payment_status'] == 'cancel') {
        return json_encode([
          "data" => $messages['cancel'],
          "status_code" => 401
        ]);
      }
      if ($token_type == "word" && ((int) $user["meta"]["word_token_amount"] ?? 0) <= 0) {
        return json_encode([
          "data" => $messages['words'],
          "status_code" => 401
        ]);
      }
      if ($token_type == "image" && ((int) $user["meta"]["image_token_amount"] ?? 0) <= 0) {
        return json_encode([
          "data" => $messages['images'],
          "status_code" => 401
        ]);
      }
    }
    return false;
  }

  public function ultimate_ai_chat_api_controller()
  {

    //send the header first so that connection dont get close
    $this->send_stream_mime_type();
    $this->must_fields_error_for_stream(["template_id"]);

    //restrict user if dont have token
    $res_json = $this->restrict_user_by_token("word");

    if ($res_json) {
      echo "event: rstrc\n";
      echo "data: " . $res_json . "\n\n";
      ob_end_flush();
    }


    $template_id = (int)sanitize_text_field($_GET["template_id"]);
    $open_api = new UltimateAI_OpenAI_API_Manager();
    $input_perametar = $this->generate_prompt_for_open_ai($template_id);


    try {
      $open_api->get_chat_completion_api_result_as_stream($input_perametar, "", 2000);
    } catch (Exception $e) {
      $error = "Sorry, there was an error in the connection. Try again later.";
      echo "data: " . json_encode(["content" => $error]) . "\n\n";
    }

    echo "event: stop\n";
    echo "data: " . $input_perametar[0]["content"]  . "\n\n";
    flush();
  }

  public function ultimate_ai_chat_completin_api_controller()
  {
    //send the header first so that connection dont get close
    $this->send_stream_mime_type();
    $this->must_fields_error_for_stream(array("history_id", "message")); //message is the letest user prompt

    //restrict user if dont have token
    $res_json = $this->restrict_user_by_token("word");

    if ($res_json) {
      echo "event: rstrc\n";
      echo "data: " . $res_json . "\n\n";
      ob_end_flush();
    }

    $history_id = (int) sanitize_text_field($_GET["history_id"]);
    $message = sanitize_textarea_field($_GET["message"]);
    $user = wp_get_current_user();

    $open_api = new UltimateAI_OpenAI_API_Manager();
    $history_manager = new Ultimate_AI_History_Manager();

    $data = $history_manager->get_history_by_id($user, $history_id);
    if (empty($data["messages"])) {
      $messages = array();
    } else {
      $messages = $data["messages"];
    }

    $new_messages = array();
    foreach ($messages as $msg) {
      $new_messages[] = array("role" => $msg["role"], "content" => $msg["content"]);
    }

    $new_messages[] = array("role" => "user", "content" => $message);


    //send some data if its need on first receive, like prompt
    echo "event: init_data\n";
    echo "data: " . json_encode($new_messages)  . "\n\n";
    flush();

    try {
      $open_api->get_chat_completion_api_result_as_stream($new_messages, "", 2000);
    } catch (Exception $e) {
      $error = "Sorry, there was an error in the connection. Try again later.";
      echo "data: " . json_encode(["content" => $error]) . "\n\n";
    }

    echo "event: stop\n";
    echo "data: " . json_encode($new_messages)  . "\n\n";
    flush();
  }

  public function ultimate_ai_text_to_speech_controller()
  {
    $open_api = new UltimateAI_OpenAI_API_Manager();
    $text = $_POST['text'];
    $voice = $_POST['voice'];

    $res = $open_api->get_text_to_speech_api_result($text, $voice);

    wp_send_json($res, 200);
  }

  public function ultimate_ai_create_image_controller()
  {
    $must_fields = array("prompt", "ai_name", "image_size", "ai_model_id", "number_of_image");
    $this->must_fields_error($must_fields);
    //restrict user if dont have token
    $res_json = $this->restrict_user_by_token("image");
    if ($res_json) {
      wp_send_json(["data" => json_decode($res_json)], 401);
    }


    $image_input_data = [];
    foreach ($must_fields as $field) {
      $image_input_data[$field] = sanitize_textarea_field($_POST[$field]);
    }
    $optional_fields = ["image_style", "negative_prompt", "aspect_ratio", "image_seed", "image_upschale_number", "image_similarity"];
    foreach ($optional_fields as $o_field) {
      if (!empty($_POST[$o_field])) {
        $image_input_data[$o_field] = sanitize_textarea_field($_POST[$o_field]);
      } else {
        $image_input_data[$o_field] = null;
      }
    }

    $img_sizes = array("small", "medium", "large", "extra_large");
    if (!in_array($image_input_data["image_size"], $img_sizes)) {
      wp_send_json("Wrong image size", 401);
    }


    $open_api = new UltimateAI_OpenAI_API_Manager();
    $sd_manager = new Ultimate_AI_SD_Manager();

    //MAKING THE PROMPT
    $prompt = $image_input_data["prompt"];
    if (!empty($image_input_data["image_style"])) $prompt = $prompt . " Image style should be " . $image_input_data["style"];
    if (!empty($image_input_data["negative_prompt"])) $prompt = $prompt . " Make sure image dont have this criteria:" . $image_input_data["negative_prompt"];


    //ai_name:OPENAI/SD
    if ($image_input_data["ai_name"]  == "SD") {
      $over_write_args = [
        "prompt" => $image_input_data["prompt"],
        "negative_prompt" => $image_input_data["negative_prompt"],
        "samples" => $image_input_data["number_of_image"],
        "size" => $image_input_data["image_size"], //size get replace with width/height  
        "model_id" => $image_input_data["ai_model_id"],
        "seed" => (int)$image_input_data["image_seed"],
        "upscale" => (int)$image_input_data["image_upschale_number"],
      ];

      $res = $sd_manager->ultimate_ai_sd_create_image($over_write_args);
    }

    //ai_name:OPENAI/SD
    if ($image_input_data["ai_name"]  == "OPENAI") {
      $over_write_args = [];
      //dall_e_3/dall_e_2
      if ($image_input_data["ai_model_id"] == "dall_e_3") {
        $over_write_args["model"] = "dall-e-3";
        $over_write_args["n"] = 1;
        $over_write_args["quality"] = "hd";
        $over_write_args["style"] = "vivid";
        if (!in_array($image_input_data["image_size"], ["large", "extra_large"])) {
          $image_input_data["image_size"] = "large";
        }
      }

      $res = $open_api->get_image_generation_api_result(
        $prompt,
        $image_input_data["image_size"],
        (int)$image_input_data["number_of_image"],
        $over_write_args
      );
    }

    wp_send_json(array("data" => $res), 200);
  }

  public function ultimate_ai_create_image_variations_controller()
  {
    $must_fields = array("prompt", "ai_name", "image_size", "ai_model_id", "number_of_image");
    $this->must_fields_error($must_fields);
    //restrict user if dont have token
    $this->restrict_user_by_token("image");

    $image_input_data = [];
    foreach ($must_fields as $field) {
      $image_input_data[$field] = sanitize_textarea_field($_POST[$field]);
    }
    $optional_fields = ["image_style", "negative_prompt", "aspect_ratio", "image_seed", "image_upschale_number", "image_similarity"];
    foreach ($optional_fields as $o_field) {
      if (!empty($_POST[$o_field])) {
        $image_input_data[$o_field] = sanitize_textarea_field($_POST[$o_field]);
      } else {
        $image_input_data[$o_field] = null;
      }
    }

    $img_sizes = array("small", "medium", "large", "extra_large");
    if (!in_array($image_input_data["image_size"], $img_sizes)) {
      wp_send_json("Wrong image size", 400);
    }

    //MAKING THE PROMPT
    $prompt = $image_input_data["prompt"];
    if ($image_input_data["style"] != "null") $prompt = $prompt . " Image style should be" . $image_input_data["style"];
    if ($image_input_data["negative_prompt"] != "null") $prompt = $prompt . " Make sure image dont have this criteria:" . $image_input_data["negative_prompt"];


    //ai_name:OPENAI/SD
    if ($image_input_data["ai_name"]  == "SD") {
      if (empty($_POST["init_image"])) wp_send_json("send image file", 400);
      $image_input_data["init_image"] = sanitize_url($_POST["init_image"]);
      $sd_manager = new Ultimate_AI_SD_Manager();

      $over_write_args = [
        "prompt" => $image_input_data["prompt"],
        "negative_prompt" => $image_input_data["negative_prompt"],
        "samples" => $image_input_data["number_of_image"],
        "size" => $image_input_data["image_size"], //size get replace with width/height  
        "model_id" => $image_input_data["ai_model_id"],
        "seed" => (int)$image_input_data["image_seed"],
        "upscale" => (int)$image_input_data["image_upschale_number"],
        "init_image" => $image_input_data["init_image"],
      ];

      $res = $sd_manager->ultimate_ai_sd_create_image_variation($over_write_args);
    }

    //ai_name:OPENAI/SD
    if ($image_input_data["ai_name"]  == "OPENAI") {
      if (!isset($_FILES["reference_image"])) wp_send_json("send image file", 400);
      $image_input_data["reference_image"] = $_FILES["reference_image"];

      $open_api = new UltimateAI_OpenAI_API_Manager();
      $res = $open_api->get_image_variations_api_result(
        $image_input_data["reference_image"],
        $image_input_data["image_size"],
        (int)$image_input_data["number_of_image"],
        array()
      );
    }

    wp_send_json(array("data" => $res), 200);
  }


  private function generate_prompt_for_open_ai($template_id)
  {
    $template_manager = new Ultimate_AI_Template_Manager();
    $template = $template_manager->ultimate_ai_get_template_by_id($template_id);

    if (!$template  || empty($template["prompt"])) {
      wp_send_json(array("data" => "Tool not found or blank prompt"), 400);
    }

    $prompt = $template["prompt"];
    $input_fields = $template["input_fields"];

    foreach ($input_fields as $field) {
      if (!empty($_GET[$field["key"]])) {
        $prompt = str_replace('[[' . $field["key"] . ']]', $_GET[$field["key"]], $prompt);
      }
    }

    return [["role" => "user",   "content" => $prompt]];
  }


  private function must_fields_error($must_fields)
  {
    foreach ($must_fields as $field) {
      if (!$_POST[$field] || empty($_POST[$field])) {
        wp_send_json(array("data" => esc_html__("Send proper informations.", ULTIMATE_AI_SLUG)), 400);
      }
    }
  }

  private function must_fields_error_for_stream($must_fields)
  {
    foreach ($must_fields as $field) {
      if (!$_GET[$field] || empty($_GET[$field])) {
        //send the header first so that connection dont get close
        header("X-Accel-Buffering: no");
        header("Content-Type: text/event-stream");
        header("Cache-Control: no-cache");
        ob_end_flush();
        echo "event: stop\n";
        echo "data: Send proper informations\n\n";
        flush();
      }
    }
  } //end


}

new UltimateAI_Article_Write_Controller();
